/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.palette;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.client.util.IPalettePlan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

public class Palette {
    private final ArrayList<ColorHolder> colors;
    private final float inPaletteCutoff;
    public static final float DEFAULT_CUTOFF = 0.007843138f;

    public Palette(float inPaletteCutoff) {
        this.colors = new ArrayList();
        this.inPaletteCutoff = inPaletteCutoff;
    }

    public Palette(List<ColorHolder> colors) {
        this.colors = new ArrayList<ColorHolder>(colors);
        this.colors.sort(ColorHolder::compareTo);
        this.inPaletteCutoff = 0.007843138f;
    }

    public Palette() {
        this(0.007843138f);
    }

    public ColorHolder getCentroid() {
        AtomicReference<Float> x = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> y = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> z = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicInteger count = new AtomicInteger();
        this.getStream().forEach(c -> {
            x.updateAndGet(v -> Float.valueOf(v.floatValue() + c.getR()));
            y.updateAndGet(v -> Float.valueOf(v.floatValue() + c.getG()));
            z.updateAndGet(v -> Float.valueOf(v.floatValue() + c.getB()));
            count.getAndIncrement();
        });
        int c2 = count.get();
        return new ColorHolder(x.get().floatValue() / (float)c2, y.get().floatValue() / (float)c2, z.get().floatValue() / (float)c2);
    }

    public double getStdDev() {
        AtomicReference<Double> sum = new AtomicReference<Double>(0.0);
        ColorHolder c = this.getCentroid();
        this.getStream().forEach(x -> {
            double d = c.distanceToLab((ColorHolder)x);
            sum.updateAndGet(v -> v + d * d);
        });
        return Math.sqrt(sum.get());
    }

    public boolean isInPalette(ColorHolder color) {
        return this.isInPalette(color, this.inPaletteCutoff);
    }

    public boolean isInPalette(ColorHolder color, float cutoff) {
        if (color.getA() == 0.0f) {
            return false;
        }
        for (ColorHolder c : this.colors) {
            if (!(Math.abs(c.getR() - color.getR()) < cutoff) || !(Math.abs(c.getG() - color.getG()) < cutoff) || !(Math.abs(c.getB() - color.getB()) < cutoff)) continue;
            return true;
        }
        return false;
    }

    public ColorHolder getColor(int i) {
        return this.colors.get(i);
    }

    public Stream<ColorHolder> getStream() {
        return this.colors.stream();
    }

    public void tryAdd(ColorHolder c) {
        if (!this.isInPalette(c)) {
            this.colors.add(c);
            Collections.sort(this.colors);
        }
    }

    public ColorHolder averageColor() {
        int t = 0;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (ColorHolder c : this.colors) {
            ++t;
            r += c.getR();
            g += c.getG();
            b += c.getB();
        }
        return new ColorHolder(r / (float)t, g / (float)t, b / (float)t);
    }

    public int closestTo(ColorHolder holder) {
        int index = 0;
        int outIndex = 0;
        double minDist = 2.0;
        for (ColorHolder c : this.colors) {
            if (c.distanceToLab(holder) < minDist) {
                outIndex = index;
                minDist = c.distanceToLab(holder);
            }
            ++index;
        }
        return outIndex;
    }

    public static Palette extractPalette(NativeImage image, int extend, float inPaletteCutoff) {
        int w = image.m_84982_();
        int h = image.m_85084_();
        Palette palette = new Palette(inPaletteCutoff);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int c_int = image.m_84985_(x, y);
                ColorHolder c = ColorHolder.fromColorInt(c_int);
                if (c.getA() == 0.0f || palette.isInPalette(c)) continue;
                palette.colors.add(new ColorHolder(c.getR(), c.getG(), c.getB()));
            }
        }
        palette.extendPalette(extend);
        return palette;
    }

    public static Palette extractPalette(NativeImage image, int extend) {
        return Palette.extractPalette(image, extend, 0.007843138f);
    }

    public Palette extendPalette(int extend) {
        Collections.sort(this.colors);
        while (this.colors.size() < extend) {
            ColorHolder high = this.colors.get(this.colors.size() - 1);
            ColorHolder low = this.colors.get(0);
            ColorHolder highNew = new ColorHolder(high.getR() * 0.9f + 0.1f, high.getG() * 0.9f + 0.1f, high.getB() * 0.9f + 0.1f);
            ColorHolder lowNew = new ColorHolder(low.getR() * 0.9f, low.getG() * 0.9f, low.getB() * 0.9f);
            this.colors.add(highNew);
            this.colors.add(0, lowNew);
        }
        return this;
    }

    public ColorHolder getColorAtRamp(float pos) {
        int index = Math.round(pos * (float)(this.colors.size() - 1));
        return this.colors.get(index);
    }

    public int getSize() {
        return this.colors.size();
    }

    /*
     * Exception decompiling
     */
    public static NativeImage paletteCombinedImage(IPalettePlan plan) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public double dist(Palette other) {
        double d = 0.0;
        int c = 0;
        ColorHolder cent = other.getCentroid();
        for (ColorHolder c1 : this.colors) {
            ++c;
            d += c1.distanceToLS(cent);
        }
        return d / (double)c;
    }

    public float getCutoff() {
        return this.inPaletteCutoff;
    }
}

